﻿var recodeApply = {
    context: $(".v-apply-recode"),
    initialize: function () {
        option = $("input[name='RecodeType']:checked").val();
        recodeApply.toggleRecode(option);

        $("input[name='RecodeType']").each(function () {
            var option = $(this).val();

            if (option == "FindAndReplace")
                haveAccess = voxco.security.has('CAN_USE_FIND_AND_REPLACE');
            if (option == "Replace")
                haveAccess = voxco.security.has('MODIFY_CODE');
            if (option == "AddCode")
                haveAccess = voxco.security.has('CREATE_CODE');

            $(this).closest(".list-item").toggle(haveAccess);
        });
    },
    bindEvents: function () {

        recodeApply.context.on("change", "input[name='RecodeType']", function () {
            recodeApply.toggleRecode($(this).val());
        });

        recodeApply.context.on("click", "#submit1", function () {
            var rows = a4.parent().openEndCoding.datatable.a4datatable("getSelectedItems");
            var respondentCases = [];

            var applyCodeSelectorParams = {
                projectId: $("#ProjectId", recodeApply.context).val(),
                questionName: $("#QuestionName", recodeApply.context).val(),
                applyToSelection: $("input[name='ApplyToSelection']:checked").val() == "True",
                recodeType: $("input[name='RecodeType']:checked").val(),
                searchInType: $("input[name='SearchInType']:checked").val(),
                findCode: $("#FindCode", recodeApply.context).val(),
                replaceCode: $("#ReplaceCode", recodeApply.context).val(),
                caseFilter: a4.parent().openEndCoding.caseFilter
            };

            if (applyCodeSelectorParams.recodeType == "FindAndReplace" && !applyCodeSelectorParams.findCode) {
                var message = recodeResources.AttributeEmpty.replace('{0}', recodeResources.FindCode);
                a4.showErrorMessage(message);
            }
            else if (!applyCodeSelectorParams.replaceCode) {
                var message = applyCodeSelectorParams.recodeType == "AddCode" ? recodeResources.AttributeEmpty.replace('{0}', recodeResources.AddCode) : recodeResources.AttributeEmpty.replace('{0}', recodeResources.ReplaceCode);
                a4.showErrorMessage(message);
            }
            else {
                _.each(rows, function (row) {
                    respondentCases.push({ CaseId: row.CaseId, Mention: row.Mention });
                });

                applyCodeSelectorParams.respondentCasesJSON = JSON.stringify(respondentCases);

                a4.callServerMethod(a4.getProjectAction("ApplyRecode", "Data"), applyCodeSelectorParams, function (result) {
                    if (result.message) {
                        var showMessage = (result.message.length > 500) ? result.message.substr(0, 500) + " ... " : result.message;
                        a4.showErrorMessage(showMessage);
                    }
                    else {
                        a4.parent().openEndCoding.refreshContent();
                        modalDialog.close();
                    }
                });
            }
        });
    },
    toggleRecode: function (option) {
        $("#FindCode").closest(".section").toggle(option == "FindAndReplace");
        switch (option) {
            case "FindAndReplace":  $(".v-replaceCodeSection .title label").text(recodeResources.ReplaceWith); break;
            case "AddCode":         $(".v-replaceCodeSection .title label").text(recodeResources.AddCode); break;
            case "Replace":         $(".v-replaceCodeSection .title label").text(recodeResources.ReplaceCode); break;
        }
    }
};

$(document).ready(function () {
    if (recodeApply.context.length > 0) {
        recodeApply.initialize();
        recodeApply.bindEvents();
    }
});